using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
		{
			QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
        }

        public QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT GetItemByActivityId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_getitemByActivityId(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    //LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_LIST> GetSurveyItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STATUSID, Int32 ACTIVITYTYPEID, string LASTNAME, string ORDERBY, string SORTBY)
        {
            List<QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_LIST> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_getSurveyItems(CURRENT_USER, CURRENT_REGISTRY_ID, STATUSID, ACTIVITYTYPEID, LASTNAME, ORDERBY, SORTBY).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT objSave)
		{
			Int32? objReturn = objSave.ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.Blast_Explosion_Ind, objSave.BRANCH_OF_SERVICE_AIRFORCE, objSave.BRANCH_OF_SERVICE_ARMY, objSave.BRANCH_OF_SERVICE_MARINES, objSave.BRANCH_OF_SERVICE_NATIONALGUARD, objSave.BRANCH_OF_SERVICE_NAVY, objSave.BRANCH_OF_SERVICE_RESERVE, objSave.Branch_of_Services, objSave.Bullet_Injury_Ind, DateTime.Now, objSave.CREATEDBY, objSave.CURRENTLY_CHEW_TOBACCO_FLAG, objSave.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG, objSave.Date_Urine_Collected, objSave.DEVICE_IMPLANTED_DENTAL_IMPLANTS_FLAG, objSave.DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL_FLAG, objSave.DEVICE_IMPLANTED_LOCATION1, objSave.DEVICE_IMPLANTED_LOCATION2, objSave.DEVICE_IMPLANTED_LOCATION3, objSave.DEVICE_IMPLANTED_LOCATION4, objSave.DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS_FLAG, objSave.DEVICE_IMPLANTED_NONE_FLAG, objSave.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC, objSave.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG, objSave.DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR_FLAG, objSave.DEVICE_IMPLANTED_STENTS_FLAG, objSave.DEVICE_IMPLANTED_SURGICAL_CLIPS_FLAG, objSave.DEVICE_IMPLANTED_YEAR1, objSave.DEVICE_IMPLANTED_YEAR2, objSave.DEVICE_IMPLANTED_YEAR3, objSave.DEVICE_IMPLANTED_YEAR4, objSave.Distance_from_Explosion_Meter, objSave.FORM_2009_FLAG, objSave.FORM_2012_FLAG, objSave.Form_Complete_Date, objSave.Fragment_Remains_inPatient_Ind, objSave.HAVE_METAL_TEETH_BRACES_FLAG, objSave.HAVE_NONE_ABOVE_FLAG, objSave.HAVE_PIERCINGS_FLAG, objSave.HAVE_TATOOS_FLAG, ref objReturn, objSave.Injured_by_EnemyFire_FLAG, objSave.Injured_by_FriendlyFire_FLAG, objSave.Injured_by_Grenade_FLAG, objSave.Injured_by_IED_FLAG, objSave.Injured_by_LandMine_FLAG, objSave.Injured_by_OtherSource_Desc, objSave.Injured_by_OtherSource_FLAG, objSave.Injured_by_RPG_FLAG, objSave.Injured_by_UnknownSource_FLAG, objSave.Injured_on_Vehicle_Ind, objSave.Injury_Abdomen, objSave.Injury_Back_Head, objSave.Injury_Back_Neck, objSave.Injury_Buttocks, objSave.Injury_Chest, objSave.Injury_City, objSave.Injury_Day, objSave.Injury_Front_Head, objSave.Injury_Front_Neck, objSave.Injury_Geographical_Location, objSave.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN, objSave.INJURY_GEOGRAPHICAL_LOCATION_IRAQ, objSave.Injury_Geographical_Location_other, objSave.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION, objSave.Injury_Groin_Pelvis, objSave.Injury_Left_Ankle, objSave.Injury_Left_Foot_Toes, objSave.Injury_Left_Hand_Wrist_Fingers, objSave.Injury_Left_Knee, objSave.Injury_Left_Lower_Arm, objSave.Injury_Left_Lower_Leg, objSave.Injury_Left_Shoulder, objSave.Injury_Left_Upper_Arm, objSave.Injury_Left_Upper_Leg_Thigh, objSave.Injury_Lower_Back, objSave.Injury_Month, objSave.Injury_Right_Ankle, objSave.Injury_Right_Foot_Toes, objSave.Injury_Right_Hand_Wrist_Fingers, objSave.Injury_Right_Knee, objSave.Injury_Right_Lower_Arm, objSave.Injury_Right_Lower_Leg, objSave.Injury_Right_Shoulder, objSave.Injury_Right_Upper_Arm, objSave.Injury_Right_Upper_Leg_Thigh, objSave.Injury_Upper_Back, objSave.Injury_Year, objSave.Other_Foreign_Material_Desc, objSave.Other_Foreign_Material_DescLoca, objSave.Other_Foreign_Material_Ind, objSave.PAST_YEAR_ANTI_FOULANT_FLAG, objSave.PAST_YEAR_DEMOLITION_FLAG, objSave.PAST_YEAR_FIRING_RANGE_USE_FLAG, objSave.PAST_YEAR_FISHING_WEIGHTS_FLAG, objSave.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC, objSave.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG, objSave.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG, objSave.PAST_YEAR_JEWELRY_OR_ART_METALS_FLAG, objSave.PAST_YEAR_LEAD_PAINT_FLAG, objSave.PAST_YEAR_MACHINING_FLAG, objSave.PAST_YEAR_MAKING_BULLETS_FLAG, objSave.PAST_YEAR_MINING_FLAG, objSave.PAST_YEAR_NOT_WORKED_IN_OCCUPATION_HOBBY_FLAG, objSave.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC, objSave.PAST_YEAR_OTHER_MANUFACTURING_FLAG, objSave.PAST_YEAR_SAND_BLASTING_FLAG, objSave.PAST_YEAR_SMELTING_FLAG, objSave.PAST_YEAR_SOLDERING_FLAG, objSave.PAST_YEAR_STAINED_GLASS_FLAG, objSave.PAST_YEAR_WELDING_FLAG, objSave.PAST_YEAR_WOOD_PRESERVATIVES_FLAG, objSave.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG, objSave.PRIMARY_WATER_PRIVATE_WELL_FLAG, objSave.Remain_in_Abdomen, objSave.Remain_in_Back_Head, objSave.Remain_in_Back_Neck, objSave.Remain_in_Buttocks, objSave.Remain_in_Chest, objSave.Remain_in_Front_Head, objSave.Remain_in_Front_Neck, objSave.Remain_in_Groin_Pelvis, objSave.Remain_in_Left_Ankle, objSave.Remain_in_Left_Foot_Toes, objSave.Remain_in_Left_Hand_Wrist_Fingers, objSave.Remain_in_Left_Knee, objSave.Remain_in_Left_Lower_Arm, objSave.Remain_in_Left_Lower_Leg, objSave.Remain_in_Left_Shoulder, objSave.Remain_in_Left_Upper_Arm, objSave.Remain_in_Left_Upper_Leg_Thigh, objSave.Remain_in_Lower_Back, objSave.Remain_in_Right_Ankle, objSave.Remain_in_Right_Foot_Toes, objSave.Remain_in_Right_Hand_Wrist_Fingers, objSave.Remain_in_Right_Knee, objSave.Remain_in_Right_Lower_Arm, objSave.Remain_in_Right_Lower_Leg, objSave.Remain_in_Right_Shoulder, objSave.Remain_in_Right_Upper_Arm, objSave.Remain_in_Right_Upper_Leg_Thigh, objSave.Remain_in_Upper_Back, objSave.ROUTINELY_USE_AYURVEDIC_MEDS_FLAG, objSave.ROUTINELY_USE_DENTURE_CREAM_FLAG, objSave.ROUTINELY_USE_DIETARY_SUPPLEMENTS_FLAG, objSave.ROUTINELY_USE_NONE_ABOVE_FLAG, objSave.ROUTINELY_USE_VITAMINS_FLAG, objSave.ROUTINELY_USE_ZINC_SUNBLOCK_FLAG, objSave.Send_to_Lab_Analysis_Ind, objSave.Shrapnel_Frag_Bullet_Surgery_Ind, objSave.Shrapnel_In_Body_Desc, objSave.Shrapnel_In_Body_DescLoca, objSave.Shrapnel_In_Body_Ind, objSave.Treated_In_the_Where, objSave.TREATLOCAT_FACILITY, objSave.TREATLOCAT_FACILITY_Where, objSave.TREATLOCAT_FIELD, objSave.TREATLOCAT_FIELD_Where, objSave.TREATLOCAT_GERMANY, objSave.TREATLOCAT_MEDCENTER, objSave.TREATLOCAT_MEDCENTER_Where, objSave.TREATLOCAT_SUPPORTHOSP, objSave.TREATLOCAT_SUPPORTHOSP_Where, DateTime.Now, objSave.UPDATEDBY, objSave.Urine_Collection_Ind, objSave.VAMC_City, objSave.VAMC_Country, objSave.VAMC_Name, objSave.VAMC_PostalCiode, objSave.VAMC_State, objSave.VAMC_Street_Address1, objSave.VAMC_Street_Address2, objSave.VAMC_Street_Address3, objSave.VAMC_ZipPlus4, objSave.Who_Referred_You, objSave.Who_Referred_You_Other, objSave.WKF_CASE_ACTIVITY_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
